#pragma once
#include "resource.h"

namespace RTCam{

class Texture1D : public Resource
{
public:
	explicit Texture1D(_In_z_ const char* name);
	~Texture1D(void);

	void InitFromChart(_In_ ID3D11Device1* device, _In_ float* chartValues, size_t dataLength);

	ComPtr<ID3D11Texture1D> m_texture;
	ComPtr<ID3D11ShaderResourceView> m_shaderView;

protected:
	void InitTexture(_In_ ID3D11Device1* device, size_t width, DXGI_FORMAT texFormat, DXGI_FORMAT srvFormat, int bindFlags, const void* initialData = nullptr, bool mipmapEnabled = false);

	size_t m_width;

private:
	bool m_mipmapEnabled;
};

} // end namespace